local super = require "NumberFormatter"

DecimalFormatter = super:new()

local defaults = {
    decimals = 1,
    groupings = true,
}

local nilDefaults = {
}

local inspectorInfo = {
    {'number', {'decimals'}, 'Decimals'},
    {'boolean', {'groupings'}, 'Groupings'},
}

function DecimalFormatter:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function DecimalFormatter:getFormatter()
    return NumberStringFormatter:decimal()
end

function DecimalFormatter:getArguments()
    return {
        self:getProperty('decimals'),
        1,
        self:getProperty('groupings'),
    }
end

function DecimalFormatter:getInspectors()
    local list = List:new()
    local inspector, hook
    inspector = Inspector:new{
        type = 'Decimal',
    }
    inspector:addHook(self:getPropertyHook('decimals'), 'decimals')
    inspector:addHook(self:getPropertyHook('groupings'), 'groupings')
    list:add(inspector)
    return list
end

return DecimalFormatter
